/*
 * Decompiled with CFR 0.152.
 */
package com.orcinus.utils;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.OctavesNoiseGenerator;

public class NoiseGenUtils {
    public static double lerpFromProgress(double ptc, double start, double end, double lowerBnd, double upperBnd) {
        return MathHelper.func_219803_d((double)NoiseGenUtils.inverseLerp(ptc, start, end), (double)lowerBnd, (double)upperBnd);
    }

    public static double clampedLerpFromProgress(double ptc, double start, double end, double lowerBnd, double upperBnd) {
        return MathHelper.func_151238_b((double)lowerBnd, (double)upperBnd, (double)NoiseGenUtils.inverseLerp(ptc, start, end));
    }

    public static double inverseLerp(double ptc, double start, double end) {
        return (ptc - start) / (end - start);
    }

    public static double sampleNoiseAndMapToRange(MaxMinNoiseMixer noise, double x, double y, double z, double lowerBound, double upperBound) {
        double value = noise.func_237211_a_(x, y, z);
        return NoiseGenUtils.lerpFromProgress(value, -1.0, 1.0, lowerBound, upperBound);
    }

    public static double biasTowardsExtreme(double min, double max) {
        return min + Math.sin(Math.PI * min) * max / Math.PI;
    }

    public static MaxMinNoiseMixer create(SharedSeedRandom seedRandom, int offset, double ... octaves) {
        return new MaxMinNoiseMixer(seedRandom, offset, (DoubleList)new DoubleArrayList(octaves));
    }

    public static class MaxMinNoiseMixer {
        private final double field_237208_a_;
        private final OctavesNoiseGenerator field_237209_b_;
        private final OctavesNoiseGenerator field_237210_c_;

        public MaxMinNoiseMixer func_242930_a(SharedSeedRandom p_242930_0_, int p_242930_1_, DoubleList p_242930_2_) {
            return new MaxMinNoiseMixer(p_242930_0_, p_242930_1_, p_242930_2_);
        }

        private MaxMinNoiseMixer(SharedSeedRandom p_i242039_1_, int p_i242039_2_, DoubleList p_i242039_3_) {
            this.field_237209_b_ = OctavesNoiseGenerator.func_242932_a((SharedSeedRandom)p_i242039_1_, (int)p_i242039_2_, (DoubleList)p_i242039_3_);
            this.field_237210_c_ = OctavesNoiseGenerator.func_242932_a((SharedSeedRandom)p_i242039_1_, (int)p_i242039_2_, (DoubleList)p_i242039_3_);
            int i = Integer.MAX_VALUE;
            int j = Integer.MIN_VALUE;
            DoubleListIterator doublelistiterator = p_i242039_3_.iterator();
            while (doublelistiterator.hasNext()) {
                int k = doublelistiterator.nextIndex();
                double d0 = doublelistiterator.nextDouble();
                if (d0 == 0.0) continue;
                i = Math.min(i, k);
                j = Math.max(j, k);
            }
            this.field_237208_a_ = 0.16666666666666666 / MaxMinNoiseMixer.func_237212_a_(j - i);
        }

        private static double func_237212_a_(int p_237212_0_) {
            return 0.1 * (1.0 + 1.0 / (double)(p_237212_0_ + 1));
        }

        public double func_237211_a_(double p_237211_1_, double p_237211_3_, double p_237211_5_) {
            double d0 = p_237211_1_ * 1.0181268882175227;
            double d1 = p_237211_3_ * 1.0181268882175227;
            double d2 = p_237211_5_ * 1.0181268882175227;
            return (this.field_237209_b_.func_205563_a(p_237211_1_, p_237211_3_, p_237211_5_) + this.field_237210_c_.func_205563_a(d0, d1, d2)) * this.field_237208_a_;
        }
    }
}

